<?php

namespace App\Controllers;

use App\Models\CertificateModel;

class CertificatesController extends BaseController
{
    protected $certificateModel;

    public function __construct()
    {
        $this->certificateModel = new CertificateModel();
    }

    public function index()
    {
        $search = $this->request->getGet('search') ?? '';
        $filter = [
            'penerbit' => $this->request->getGet('penerbit') ?? '',
            'tanggal_dari' => $this->request->getGet('tanggal_dari') ?? '',
            'tanggal_sampai' => $this->request->getGet('tanggal_sampai') ?? ''
        ];
        $sort = $this->request->getGet('sort') ?? 'tanggal_terbit';
        $order = $this->request->getGet('order') ?? 'DESC';
        $page = (int)($this->request->getGet('page') ?? 1);

        $builder = $this->certificateModel->searchAndFilter($search, $filter, $sort, $order);
        $total = $builder->countAllResults(false);
        
        $perPage = 5;
        $certificates = $builder->get($perPage, ($page - 1) * $perPage)->getResultArray();

        $pager = \Config\Services::pager();
        $pager->store('certificates', $page, $perPage, $total);
        
        // Calculate last page manually to ensure it works
        $lastPage = (int) ceil($total / $perPage);

        $data = [
            'title' => 'Sertifikat - Portfolio',
            'certificates' => $certificates,
            'pager' => $pager,
            'lastPage' => $lastPage,
            'currentPage' => $page,
            'total' => $total,
            'search' => $search,
            'filter' => $filter,
            'sort' => $sort,
            'order' => $order
        ];

        return view('certificates/index', $data);
    }
}

